$(function(){

	var url = {
		currentURL: function(){
			return window.location.href;
		},
		baseURL: function(){
			return $("base").attr('href');
		},
		isHomePage: function(){
			if(url.currentURL() == url.baseURL()){
				return true;
			}else{
				return false;
			}
		}
	}

    init_masonry();

    $("[rel='tooltip']").tooltip({"placement":"bottom"});

	var page = {
	    init: function () {
	        page.reorganize();
	    },
	    getViewportWidth: function () {
	        return "undefined" != typeof window.innerWidth ? window.innerWidth : "undefined" != typeof document.documentElement && "undefined" != typeof document.documentElement.clientWidth && 0 != document.documentElement.clientWidth ? document.documentElement.clientWidth : document.getElementsByTagName("body")[0].clientWidth
	    },
	    determineWidth: function () {
	        var a = {};
	        a.width = page.getViewportWidth();
	        1200 <= a.width && (a.name = "BigDesktop");
	        999 < a.width && 1200 >= a.width && (a.name = "SmallDesktop");
	        768 <= a.width && 999 >= a.width && (a.name = "LandscapeTablet");
	        480 < a.width && 768 > a.width && (a.name = "PortraitTablet");
	        480 >= a.width && (a.name = "Mobile");
	        return a
	    },
	    reorganize: function () {
	        var a = page.determineWidth();
	        switch (a.name) {
	            case "BigDesktop":
	            case "SmallDesktop":
	                desktopSearch();
	                $(".leftPanel").css({"height": $(window).height()-120});
	                
	                break;
	            case "LandscapeTablet":
	            	tabletSearch();
	            	$(".leftPanel").css({"height": $(window).height()-120});
	                
	                break;
	            case "PortraitTablet":
	            	$(".leftPanel").css({"height": "100px"});
	                
	                break;
	            case "Mobile":
	                $(".leftPanel").css({"height": "170px"});
	        }
	    }
	}
	page.init();
	$(window).resize(function () {
            page.reorganize();
    });
    $("#collapsed-navbar ."+$('body').attr('class')).attr('selected', 'selected');
	$("#collapsed-navbar").change(function () {
        window.location = $(this).val();
    });

	$("#fullSearch").submit(function(){
			var val = $("#imageSearch").val();
			window.location ="/search/"+val.replace(/\s/g, "+");
			return false;
	});
	function tabletSearch(){
		$(".full-search").off("hover");
		var a= page.determineWidth();
		if(a.name == "LandscapeTablet" && !url.isHomePage()){
			$(window).scroll(function() {
				if($(document).scrollTop() == 0) {
					$(".full-search").stop().removeClass("span2").animate({ 
						"margin-top" : "0px", 
						"margin-left" : ($(".leftPanel").outerWidth()-14) + "px",
						"width":"72%"
					}, 200);
					$(".searchTrigger").fadeOut("fast", function(){
						$(".search-item").fadeIn();
					});
				} else if( $(document).scrollTop() > 0 && $(window).scrollTop() + $(window).height() < $(document).height() ){
					$(".full-search").stop().addClass("span2").animate({ 
							"margin-top" : "-60px",
							"margin-left" : "-25px", 
							"width": "140px"
					}, 200);
					$(".search-item").fadeOut("fast", function(){
						$(".searchTrigger").fadeIn();
					});
				}
			});
			$(".searchExpend").live("click", function(){
				$("html, body").stop().animate({ scrollTop: 0 }, "slow");
				return false;
			});
		}else if(a.name == "PortraitTablet" && !url.isHomePage()){
			$(window).scroll(function() {
				if($(document).scrollTop() == 0) {
					$(".full-search").stop().removeClass("span2").animate({ 
						"margin-top" : "0px", 
						"margin-left" : ($(".leftPanel").outerWidth()-14) + "px",
						"width":"72%"
					}, 200);
					$(".searchTrigger").fadeOut("fast", function(){
						$(".search-item").fadeIn();
					});
				} else if( $(document).scrollTop() > 0 && $(window).scrollTop() + $(window).height() < $(document).height() ){
					$(".full-search").stop().addClass("span2").animate({ 
							"margin-top" : "-60px",
							"margin-left" : "-25px", 
							"width": "140px"
					}, 200);
					$(".search-item").fadeOut("fast", function(){
						$(".searchTrigger").fadeIn();
					});
				}
			});
			$(".searchExpend").live("click", function(){
				$("html, body").stop().animate({ scrollTop: 0 }, "slow");
				return false;
			});
		}else if(a.name == "LandscapeTablet"){
			$(window).scroll(function() {
				var search = $(".full-search").children();
				if($(document).scrollTop() == 0) {
						search.stop().animate({ "opacity" : 1}, 300);
						
					} else if( $(window).scrollTop() + $(window).height() == $(document).height() ){
						search.stop().animate({ "opacity" : 1}, 300);
						
					} else if( $(document).scrollTop() > 100 && $(window).scrollTop() + $(window).height() < $(document).height() ){
						search.stop().animate({ "opacity" : .7}, 300);
						
				}
			});
		}else if(a.name == "PortraitTablet"){
			$(".full-search").stop().removeClass("span2").animate({ 
						"margin-top" : "0px", 
						"margin-right" : "0px",
						"width":"50%"
					}, 200);
		}
	}
	function desktopSearch(){
		$(window).off("scroll");
		var a= page.determineWidth();
		if(a.name == "BigDesktop" || a.name == "SmallDesktop"){

			$(".SearchExpend").remove();
			$(".full-search").affix();
			var search = $(".full-search").children();
			if(!url.isHomePage()){
				$(".full-search").stop().removeClass("span2").animate({ 
							"margin-left" : ($(".leftPanel").outerWidth()-15) + "px",
							"width":"72%"
				}, 200);
			}
			$(window).scroll(function() {
				
				if($(document).scrollTop() == 0) {
					search.stop().animate({ "opacity" : 1}, 300);
					$(".full-search").stop().animate({ "margin-top" : 0}, 200);
				} else if( $(window).scrollTop() + $(window).height() == $(document).height() ){
					search.stop().animate({ "opacity" : 1}, 300);
					$(".full-search").stop().animate({ "margin-top" : 0}, 200);
				} else if( $(document).scrollTop() > 100 && $(window).scrollTop() + $(window).height() < $(document).height() ){
					search.stop().animate({ "opacity" : .7}, 300);
					$(".full-search").stop().animate({ "margin-top" : "-50px"}, 100);
				}
			});
		
			$(".full-search").hover(
			function () {
				search.stop().animate({ "opacity" : 1}, 200);
				$(".full-search").stop().animate({ "margin-top" : 0}, 200);
			},
			function () {
				if($(document).scrollTop() !== 0) {
					search.stop().animate({ "opacity" : .7}, 300);
					$(".full-search").stop().animate({ "margin-top" : "-50px"}, 100);
				}
			});
			
		}
		$("#imageSearch").focus(function() {
		  		$(".full-search").stop().animate({ "margin-top" : 0}, 200);
			});
	}

	function init_masonry(){
	    var $container = $('#content');

	    var gutter = 12;
	    var min_width = 200;
	    $container.imagesLoaded( function(){
	        $container.masonry({
	            itemSelector : '.box',
	            gutterWidth: gutter,
	            isAnimated: true,
	              columnWidth: function( containerWidth ) {
	                var num_of_boxes = (containerWidth/min_width | 0);

	                var box_width = (((containerWidth - (num_of_boxes-1)*gutter)/num_of_boxes) | 0) ;

	                if (containerWidth < min_width) {
	                    box_width = containerWidth;
	                }

	                $('.box').width(box_width);

	                return box_width;
	              }
	        });
	    });
	}
});






